<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kelola Karyawan - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 260px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .sidebar-footer { position: absolute; bottom: 1rem; width: calc(100% - 3rem); }
        .main-content { margin-left: 260px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -260px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <div class="card-header bg-white border-0 py-3 d-flex flex-wrap align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold">Daftar Pengguna</h5>
                        <div class="d-flex mt-2 mt-md-0">
                             <input type="search" class="form-control me-2" placeholder="Cari pengguna...">
                            <button class="btn btn-primary"><i class="bi bi-plus-circle-fill me-2"></i>Tambah</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Peran</th>
                                        <th scope="col">Tanggal Bergabung</th>
                                        <th scope="col">Status</th>
                                        <th scope="col" class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>Admin Koperasi</strong></td>
                                        <td>admin.ksp@bsm.com</td>
                                        <td><span class="badge bg-danger-subtle text-danger-emphasis rounded-pill">Admin</span></td>
                                        <td>01 Jan 2022</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Aktif</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></button>
                                            <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>I Gede Pratama</td>
                                        <td>gede.pratama@example.com</td>
                                        <td><span class="badge bg-primary-subtle text-primary-emphasis rounded-pill">Karyawan</span></td>
                                        <td>15 Jul 2023</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Aktif</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></button>
                                            <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ni Wayan Sudarmi</td>
                                        <td>wayan.sudarmi@example.com</td>
                                        <td><span class="badge bg-primary-subtle text-primary-emphasis rounded-pill">Karyawan</span></td>
                                        <td>20 Agu 2024</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Aktif</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></button>
                                            <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>I Made Suena S.Pt</td>
                                        <td>made.suena@example.com</td>
                                        <td><span class="badge bg-primary-subtle text-primary-emphasis rounded-pill">Karyawan</span></td>
                                        <td>05 Sep 2024</td>
                                        <td><span class="badge bg-secondary-subtle text-secondary-emphasis rounded-pill">Non-Aktif</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></button>
                                            <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Sang Guru Jati Arsika</td>
                                        <td>guru.jati@example.com</td>
                                        <td><span class="badge bg-primary-subtle text-primary-emphasis rounded-pill">Karyawan</span></td>
                                        <td>10 Nov 2024</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Aktif</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></button>
                                            <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>
</body>
</html>
<?php /**PATH C:\aplikasi-absensi\resources\views/kelolakaryawan.blade.php ENDPATH**/ ?>