<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ganti Password - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 260px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .sidebar-footer { position: absolute; bottom: 1rem; width: calc(100% - 3rem); }
        .main-content { margin-left: 260px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        .password-toggle { cursor: pointer; }
        @media (max-width: 991.98px) {
            .sidebar { left: -260px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card card-custom">
                             <div class="card-header bg-white border-0 py-3">
                                <h5 class="mb-0 fw-bold">Formulir Perubahan Password</h5>
                            </div>
                            <div class="card-body p-4">
                                <div id="alert-placeholder"></div>
                                <form action="<?php echo e(route('password.update')); ?>" method="POST">
    <?php echo csrf_field(); ?>

    <div class="mb-3">
        <label for="old-password" class="form-label">User</label>
        <div class="input-group">
            <input type="text" name="users" class="form-control" id="users" value="<?php echo e($user->name); ?>">
            <span class="input-group-text password-toggle" >
                <i class="bi bi-eye-slash"></i>
            </span>
        </div>

    </div>

    <div class="mb-3">
        <label for="old-password" class="form-label">Password Lama</label>
        <div class="input-group">
            <input type="password" name="current_password" class="form-control" id="old-password" required>
            <span class="input-group-text password-toggle" onclick="togglePasswordVisibility('old-password')">
                <i class="bi bi-eye-slash"></i>
            </span>
        </div>
        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="mb-3">
        <label for="new-password" class="form-label">Password Baru</label>
        <div class="input-group">
            <input type="password" name="new_password" class="form-control" id="new-password" required>
            <span class="input-group-text password-toggle" onclick="togglePasswordVisibility('new-password')">
                <i class="bi bi-eye-slash"></i>
            </span>
        </div>
        <div class="form-text">Password harus minimal 8 karakter.</div>
        <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger small"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="mb-4">
        <label for="confirm-password" class="form-label">Konfirmasi Password Baru</label>
        <div class="input-group">
            <input type="password" name="new_password_confirmation" class="form-control" id="confirm-password" required>
            <span class="input-group-text password-toggle" onclick="togglePasswordVisibility('confirm-password')">
                <i class="bi bi-eye-slash"></i>
            </span>
        </div>
    </div>

    <div class="d-grid">
        <button type="submit" class="btn btn-primary btn-lg">Simpan Perubahan</button>
    </div>
</form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }

        function togglePasswordVisibility(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = field.nextElementSibling.querySelector('i');
            if (field.type === 'password') {
                field.type = 'text';
                icon.classList.remove('bi-eye-slash');
                icon.classList.add('bi-eye');
            } else {
                field.type = 'password';
                icon.classList.remove('bi-eye');
                icon.classList.add('bi-eye-slash');
            }
        }

    
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // SweetAlert Success
    <?php if(session('success')): ?>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '<?php echo e(session("success")); ?>',
            timer: 2000,
            showConfirmButton: false
        });
    <?php endif; ?>

    // SweetAlert Error Validasi
    <?php if($errors->any()): ?>
        Swal.fire({
            icon: 'error',
            title: 'Terjadi Kesalahan',
            html: `<?php echo implode('<br>', $errors->all()); ?>`
        });
    <?php endif; ?>
</script>

</body>
</html>
<?php /**PATH C:\aplikasi-absensi2\resources\views/karyawan/perubahanpassword.blade.php ENDPATH**/ ?>