<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kelola Karyawan - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 260px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .sidebar-footer { position: absolute; bottom: 1rem; width: calc(100% - 3rem); }
        .main-content { margin-left: 260px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -260px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <div class="card-header bg-white border-0 py-3 d-flex flex-wrap align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold">Daftar Pengguna</h5>
                        <div class="d-flex mt-2 mt-md-0">
                            <form class="d-flex me-2" method="GET" action="<?php echo e(route('karyawan.index')); ?>">
                                <input type="search" name="q" value="<?php echo e(request('q')); ?>" class="form-control me-2" placeholder="Cari pengguna...">
                            </form>
                            <a href="<?php echo e(route('karyawan.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle-fill me-2"></i>Tambah</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                        <?php endif; ?>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Peran</th>
                                        <th scope="col">Tanggal Bergabung</th>
                                        <th scope="col">Status</th>
                                        <th scope="col" class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><strong><?php echo e($user->name); ?></strong></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td><span class="badge bg-primary-subtle text-primary-emphasis rounded-pill">Karyawan</span></td>
                                        <td><?php echo e($user->created_at ? $user->created_at->format('d M Y') : '-'); ?></td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Aktif</span></td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('karyawan.edit', $user)); ?>" class="btn btn-sm btn-outline-primary" title="Edit"><i class="bi bi-pencil-fill"></i></a>
                                            <form action="<?php echo e(route('karyawan.destroy', $user)); ?>" method="POST" class="d-inline-block" onsubmit="return confirm('Hapus karyawan ini?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-outline-danger" title="Hapus"><i class="bi bi-trash-fill"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Tidak ada pengguna.</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            <?php echo e($users->links('pagination::bootstrap-5')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>
</body>
</html>
<?php /**PATH D:\LARAVEL-PROJECTS\Joki\aplikasi-absensi\resources\views/kelolakaryawan.blade.php ENDPATH**/ ?>