<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kelola Absensi - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 280px;
            padding: 1.5rem;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
            z-index: 1030;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            font-weight: 500;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #343a40;
            color: #fff;
        }

        .sidebar .nav-link i {
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }

        .sidebar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: #fff;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 1rem;
            width: calc(100% - 3rem);
        }

        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s;
            padding: 2rem;
        }

        .navbar-custom {
            padding: 1rem 2rem;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
        }

        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, .08);
        }

        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020;
        }

        .sidebar-toggler {
            display: none;
        }

        @media (max-width: 991.98px) {
            .sidebar {
                left: -280px;
            }

            .sidebar.show {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar.show~.sidebar-overlay {
                display: block;
            }

            .sidebar-toggler {
                display: block;
            }
        }
    </style>
</head>

<body>

    <!-- Sidebar -->
    <?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
        <?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <div class="card-header bg-white border-0 py-3 d-flex flex-wrap align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold">Data Absensi Karyawan</h5>
                        <form method="POST" action="/absensi">
                            <?php echo csrf_field(); ?>

                            <div class="d-flex flex-wrap align-items-center mt-2 mt-md-0">
                                <input type="date" class="form-control me-2" style="width: auto;" name="tanggal_awal" value="<?php echo e($tanggal_a); ?>">

                                <input type="date" class="form-control me-2" style="width: auto;" name="tanggal_akhir" value="<?php echo e($tanggal_b); ?>">

                                <select class="form-select me-2" style="width: auto;" name="status_filter" hidden>
                                    <option value="hadie" selected>Hadir</option>
                                    <option value="terlambat">Terlambat</option>
                                    <option value="alpha">Alpha</option>
                                </select>

                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-funnel-fill me-2"></i>Filter
                                </button>
                            </div>
                        </form>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            
                            <table class="table table-striped table-hover table-bordered align-middle">

                                
                                <thead>
                                    <tr>
                                        <th scope="col">Nama Pegawai</th>
                                        <th scope="col">Tanggal</th>
                                        <th scope="col">Masuk</th>
                                        <th scope="col">Keluar</th>
                                        <th scope="col">Keterangan</th>
                                        <th scope="col">Status</th>
                                        <!-- <th scope="col" class="text-center">Aksi</th> -->
                                    </tr>
                                </thead>

                                
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><strong><?php echo e($row->name); ?></strong></td>

                                        
                                        <td><?php echo e(\Carbon\Carbon::parse($row->tanggal)->translatedFormat('d M Y')); ?></td>

                                        
                                        <td><?php echo e($row->jam_masuk ?? '-'); ?></td>

                                        
                                        <td><?php echo e($row->jam_keluar ?? '-'); ?></td>

                                        
                                        <td><?php echo e($row->keterangan ?? '-'); ?></td>

                                        
                                        <td>
                                            <?php if($row->status == 'hadir'): ?>
                                            <span class="badge bg-success-subtle text-success-emphasis rounded-pill">Hadir</span>
                                            <?php elseif($row->status == 'terlambat'): ?>
                                            <span class="badge bg-warning-subtle text-warning-emphasis rounded-pill">Terlambat</span>
                                            <?php elseif($row->status == 'alpha'): ?>
                                            <span class="badge bg-danger-subtle text-danger-emphasis rounded-pill">Alpha</span>
                                            
                                            <?php else: ?>
                                            <span class="badge bg-secondary rounded-pill">Tidak Ada</span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- 
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit" data-bs-toggle="modal"
                                                data-bs-target="#editAbsensiModal">
                                                <i class="bi bi-pencil-fill"></i>
                                            </button>
                                        </td> -->
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">Tidak ada data absensi yang ditemukan dalam rentang ini.</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>



                        </div>
                    </div>

                </div>
            </div>
        </main>
    </div>

    <!-- Edit Absensi Modal -->
    <div class="modal fade" id="editAbsensiModal" tabindex="-1" aria-labelledby="editAbsensiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editAbsensiModalLabel">Edit Data Absensi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="mb-3">
                            <label for="namaKaryawan" class="form-label">Nama Karyawan</label>
                            <input type="text" class="form-control" id="namaKaryawan" value="I Gede Pratama" readonly>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="jamMasuk" class="form-label">Jam Masuk</label>
                                <input type="time" class="form-control" id="jamMasuk" value="07:59">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="jamPulang" class="form-label">Jam Pulang</label>
                                <input type="time" class="form-control" id="jamPulang" value="17:01">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="statusAbsensi" class="form-label">Status</label>
                            <select class="form-select" id="statusAbsensi">
                                <option selected>Tepat Waktu</option>
                                <option value="1">Terlambat</option>
                                <option value="2">Sakit</option>
                                <option value="3">Izin</option>
                                <option value="4">Alpa</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="keterangan" class="form-label">Keterangan</label>
                            <textarea class="form-control" id="keterangan" rows="3"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>
</body>

</html><?php /**PATH C:\aplikasi-absensi2\resources\views/halamanabsensiadmin.blade.php ENDPATH**/ ?>