<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 280px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .main-content { margin-left: 280px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .welcome-card { background: linear-gradient(90deg, #004a7c, #005a9c); color: white; }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -280px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
    <script>
        // Define the function in the head so it's available when the body is parsed
        function toggleSidebar() { 
            document.getElementById('sidebar').classList.toggle('show'); 
        }
    </script>
</head>
<body>

<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card card-custom welcome-card p-4">
                            <h4 class="mb-1">Selamat Datang, Admin!</h4>
                            <p class="mb-0">Berikut adalah ringkasan absensi seluruh karyawan hari ini.</p>
                        </div>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-xl-3 col-md-6"><div class="card card-custom h-100"><div class="card-body d-flex align-items-center"><div class="bg-primary text-white p-3 rounded-3 me-3"><i class="bi bi-people-fill fs-3"></i></div><div><h6 class="text-muted mb-1">Total Karyawan</h6><h4 class="mb-0 fw-bold">20</h4></div></div></div></div>
                    <div class="col-xl-3 col-md-6"><div class="card card-custom h-100"><div class="card-body d-flex align-items-center"><div class="bg-success text-white p-3 rounded-3 me-3"><i class="bi bi-person-check-fill fs-3"></i></div><div><h6 class="text-muted mb-1">Hadir Hari Ini</h6><h4 class="mb-0 fw-bold">15</h4></div></div></div></div>
                    <div class="col-xl-3 col-md-6"><div class="card card-custom h-100"><div class="card-body d-flex align-items-center"><div class="bg-warning text-dark p-3 rounded-3 me-3"><i class="bi bi-person-exclamation-fill fs-3"></i></div><div><h6 class="text-muted mb-1">Izin / Sakit</h6><h4 class="mb-0 fw-bold">2</h4></div></div></div></div>
                    <div class="col-xl-3 col-md-6"><div class="card card-custom h-100"><div class="card-body d-flex align-items-center"><div class="bg-danger text-white p-3 rounded-3 me-3"><i class="bi bi-person-x-fill fs-3"></i></div><div><h6 class="text-muted mb-1">Tidak Hadir</h6><h4 class="mb-0 fw-bold">3</h4></div></div></div></div>
                </div>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card card-custom">
                            <div class="card-header bg-white border-0 py-3"><h5 class="mb-0 fw-bold">Log Absensi Terbaru</h5></div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead><tr><th>Nama Karyawan</th><th>Tanggal</th><th>Jam Masuk</th><th>Jam Pulang</th><th>Status</th></tr></thead>
                                        <tbody>
                                            <tr><td>I Gede Pratama</td><td>15 Okt 2025</td><td>07:59</td><td>17:01</td><td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td></tr>
                                            <tr><td>I Nyoman Mertajaya</td><td>15 Okt 2025</td><td>08:01</td><td>17:05</td><td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td></tr>
                                            <tr><td>Sang Guru Jati Arsika</td><td>15 Okt 2025</td><td>08:15</td><td>17:02</td><td><span class="badge bg-warning-subtle text-warning-emphasis rounded-pill">Terlambat</span></td></tr>
                                            <tr><td>I Made Suena S.Pt</td><td>15 Okt 2025</td><td>-</td><td>-</td><td><span class="badge bg-info-subtle text-info-emphasis rounded-pill">Sakit</span></td></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php /**PATH C:\aplikasi-absensi\resources\views/dashboard.blade.php ENDPATH**/ ?>