<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kelola Absensi - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 280px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .sidebar-footer { position: absolute; bottom: 1rem; width: calc(100% - 3rem); }
        .main-content { margin-left: 280px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -280px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <div class="card-header bg-white border-0 py-3 d-flex flex-wrap align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold">Data Absensi Karyawan</h5>
                         <div class="d-flex flex-wrap align-items-center mt-2 mt-md-0">
                            <input type="date" class="form-control me-2" style="width: auto;" value="2025-10-14">
                            <select class="form-select me-2" style="width: auto;">
                                <option selected>Semua Status</option>
                                <option value="1">Tepat Waktu</option>
                                <option value="2">Terlambat</option>
                                <option value="3">Sakit</option>
                                <option value="4">Izin</option>
                                <option value="5">Alpa</option>
                            </select>
                            <button class="btn btn-primary"><i class="bi bi-funnel-fill me-2"></i>Filter</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">Nama Karyawan</th>
                                        <th scope="col">Tanggal</th>
                                        <th scope="col">Jam Masuk</th>
                                        <th scope="col">Jam Pulang</th>
                                        <th scope="col">Keterangan</th>
                                        <th scope="col">Status</th>
                                        <th scope="col" class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>I Gede Pratama</strong></td>
                                        <td>14 Okt 2025</td>
                                        <td>07:59</td>
                                        <td>17:01</td>
                                        <td>-</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit" data-bs-toggle="modal" data-bs-target="#editAbsensiModal"><i class="bi bi-pencil-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>I Nyoman Mertajaya</td>
                                        <td>14 Okt 2025</td>
                                        <td>08:01</td>
                                        <td>17:05</td>
                                        <td>-</td>
                                        <td><span class="badge bg-success-subtle text-success-emphasis rounded-pill">Tepat Waktu</span></td>
                                        <td class="text-center">
                                             <button class="btn btn-sm btn-outline-primary" title="Edit" data-bs-toggle="modal" data-bs-target="#editAbsensiModal"><i class="bi bi-pencil-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Sang Guru Jati Arsika</td>
                                        <td>14 Okt 2025</td>
                                        <td>08:15</td>
                                        <td>17:02</td>
                                        <td>Terlambat 15 menit</td>
                                        <td><span class="badge bg-warning-subtle text-warning-emphasis rounded-pill">Terlambat</span></td>
                                        <td class="text-center">
                                             <button class="btn btn-sm btn-outline-primary" title="Edit" data-bs-toggle="modal" data-bs-target="#editAbsensiModal"><i class="bi bi-pencil-fill"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>I Made Suena S.Pt</td>
                                        <td>14 Okt 2025</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>Surat dokter terlampir</td>
                                        <td><span class="badge bg-info-subtle text-info-emphasis rounded-pill">Sakit</span></td>
                                        <td class="text-center">
                                            <button class="btn btn-sm btn-outline-primary" title="Edit" data-bs-toggle="modal" data-bs-target="#editAbsensiModal"><i class="bi bi-pencil-fill"></i></button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Edit Absensi Modal -->
    <div class="modal fade" id="editAbsensiModal" tabindex="-1" aria-labelledby="editAbsensiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editAbsensiModalLabel">Edit Data Absensi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="mb-3">
                            <label for="namaKaryawan" class="form-label">Nama Karyawan</label>
                            <input type="text" class="form-control" id="namaKaryawan" value="I Gede Pratama" readonly>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="jamMasuk" class="form-label">Jam Masuk</label>
                                <input type="time" class="form-control" id="jamMasuk" value="07:59">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="jamPulang" class="form-label">Jam Pulang</label>
                                <input type="time" class="form-control" id="jamPulang" value="17:01">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="statusAbsensi" class="form-label">Status</label>
                            <select class="form-select" id="statusAbsensi">
                                <option selected>Tepat Waktu</option>
                                <option value="1">Terlambat</option>
                                <option value="2">Sakit</option>
                                <option value="3">Izin</option>
                                <option value="4">Alpa</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="keterangan" class="form-label">Keterangan</label>
                            <textarea class="form-control" id="keterangan" rows="3"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>
</body>
</html>

<?php /**PATH C:\aplikasi-absensi1\aplikasi-absensi\resources\views/absensi.blade.php ENDPATH**/ ?>