<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\KaryawanController;
use App\Http\Controllers\AbsenController;
use App\Http\Controllers\DashboardController;


Route::get('/', function () {
    return view('welcome');
});


Route::get('/dashboard', [DashboardController::class, 'dashboard'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::get('/profileorganisasi', function () {
    return view('profileorganisasi');
})->middleware(['auth', 'verified'])->name('profileorganisasi');


Route::get('/absensikaryawan', function () {
    return view('absensikaryawan');
})->middleware(['auth', 'verified'])->name('absensikaryawan');
Route::get('/profileorganisasikaryawan', function () {
    return view('profileorganisasikaryawan');
})->middleware(['auth', 'verified'])->name('profileorganisasikaryawan');

Route::get('/perubahanpasswordkaryawan', function () {
    return view('perubahanpasswordkaryawan');
})->middleware(['auth', 'verified'])->name('perubahanpasswordkaryawan');
// Karyawan CRUD routes
Route::resource('karyawan', KaryawanController::class)->middleware(['auth', 'verified']);
// keep old path for compatibility
Route::get('/kelolakaryawan', function () {
    return redirect()->route('karyawan.index');
})->middleware(['auth', 'verified'])->name('kelolakaryawan');




Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])
    ->middleware('auth')
    ->name('logout');

Route::get('/perubahanpassword', [KaryawanController::class, 'password_index'])->name('password.index');
Route::post('/perubahanpassword', [KaryawanController::class, 'password_update'])->name('password.update');

Route::get('/absensisemua', [AbsenController::class, 'absenkaryawan_show'])->name('absenkaryawan.show');
Route::post('/absen/absenkaryawan', [AbsenController::class, 'absenkaryawan_store'])->name('absenkaryawan.store');
// ========================
// ADMIN KELOLA ABSENSI
// ========================
Route::get('/absensikaryawan', [AbsenController::class, 'index'])->name('absensi.index');
Route::get('/absensi-admin/{id}/edit', [AbsenController::class, 'edit'])->name('absensi.edit');
Route::put('/absensi-admin/{id}', [AbsenController::class, 'update'])->name('absensi.update');
Route::delete('/absensi-admin/{id}', [AbsenController::class, 'destroy'])->name('absensi.destroy');

// Halaman absensi karyawan (SHOW)
Route::get('/absensikaryawan', [AbsenController::class, 'absenkaryawan_show'])
    ->middleware(['auth', 'verified'])
    ->name('absenkaryawan.show');

// Menyimpan absen masuk & pulang
Route::post('/absensikaryawan', [AbsenController::class, 'absenkaryawan_store'])
    ->middleware(['auth', 'verified'])
    ->name('absenkaryawan.store');

Route::get('/absensi', [AbsenController::class, 'dataabsensiadmin'])
    ->middleware(['auth', 'verified'])
    ->name('dataabsensiadmin.show');

Route::post('/absensi', [AbsenController::class, 'dataabsensiadmin_filter'])
    ->middleware(['auth', 'verified'])
    ->name('dataabsensiadmin.show');

Route::get('/laporan', [AbsenController::class, 'absensilaporan'])
    ->middleware(['auth', 'verified'])
    ->name('absensilaporan.show');

Route::post('/laporan', [AbsenController::class, 'absensilaporan'])
    ->middleware(['auth', 'verified'])
    ->name('absensilaporan.show');

Route::post('/laporanprint', [AbsenController::class, 'cetakPdf'])
    ->name('absensilaporan.print');

Route::post('/dashboard', [DashboardController::class, 'dashboardAdmin'])
    ->name('dashboard');

Route::get('/dashboard', [DashboardController::class, 'dashboardAdmin'])
->name('dashboard');

Route::get('/dashboard', [DashboardController::class, 'index'])
->name('dashboard')
->middleware('auth');

Route::post('/dashboard', [DashboardController::class, 'index'])
->middleware('auth');

Route::get('/dashboardkaryawan', [DashboardController::class, 'dashboardKaryawan'])
    ->name('dashboard.karyawan')
    ->middleware('auth');

Route::post('/dashboardkaryawan', [DashboardController::class, 'dashboardKaryawan'])
    ->middleware('auth'); // untuk filter bulan/tahun

    Route::get('/dashboard', [DashboardController::class, 'dashboard'])
    ->middleware('auth')
    ->name('dashboard');

    Route::middleware(['auth'])->group(function () {
        Route::get('/admin/lokasi-kantor', [LokasiKantorController::class, 'index'])
            ->name('lokasi.index');
    
        Route::post('/admin/lokasi-kantor', [LokasiKantorController::class, 'update'])
            ->name('lokasi.update');
    });
    
    Route::get('/lokasikerja', [AbsenController::class, 'lokasikerja'])
    ->middleware(['auth', 'verified'])
    ->name('lokasikerja');

Route::post('/update-radius', [AbsenController::class, 'updatelokasikerja'])
    ->middleware(['auth', 'verified'])
    ->name('lokasikerja.update');

require __DIR__ . '/auth.php';
