<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Karyawan - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 260px;
            padding: 1.5rem;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
            z-index: 1030;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            font-weight: 500;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #343a40;
            color: #fff;
        }

        .sidebar .nav-link i {
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }

        .sidebar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: #fff;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 1rem;
            width: calc(100% - 3rem);
        }

        .main-content {
            margin-left: 260px;
            transition: margin-left 0.3s;
            padding: 2rem;
        }

        .navbar-custom {
            padding: 1rem 2rem;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
        }

        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, .08);
        }

        .welcome-card {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
        }

        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020;
        }

        .sidebar-toggler {
            display: none;
        }

        @media (max-width: 991.98px) {
            .sidebar {
                left: -260px;
            }

            .sidebar.show {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar.show~.sidebar-overlay {
                display: block;
            }

            .sidebar-toggler {
                display: block;
            }
        }
    </style>
</head>

<body>

    <!-- Sidebar -->
    @include('menu.menuuser')
    <div class="sidebar-overlay" onclick="toggleSidebar()"></div>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
        @include('menu.topnavbaruser')

        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <!-- Welcome Message -->
                <div class="row mb-4">
                    <div class="col-12">
                    <div class="card card-custom welcome-card p-4">
                    <h4 class="mb-1">Selamat Datang Kembali, {{ Auth::user()->name }}</h4>
                    <p class="mb-0">
                        Berikut adalah ringkasan aktivitas absensi Anda hari ini, 
                        {{ \Carbon\Carbon::now()->translatedFormat('l, d F Y') }}.
                    </p>
                </div>

                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="row g-4">
                    <div class="col-xl-3 col-md-6">
                        <div class="card card-custom h-100">
                        <div class="card-body d-flex align-items-center">
                        <div class="bg-primary text-white p-3 rounded-3 me-3">
                            <i class="bi bi-calendar-check fs-3"></i>
                        </div>
                        <div>
                            <h6 class="text-muted mb-1">Total Kehadiran Bulan Ini</h6>
                            <h4 class="mb-0 fw-bold">{{ $total_hadir }} Hari</h4>
                        </div>
                    </div>

                    


                            </div>
                        </div>
                    </div>
                    <!-- <div class="col-xl-3 col-md-6">
                        <div class="card card-custom h-100">
                            <div class="card-body d-flex align-items-center">
                                <div class="bg-warning text-dark p-3 rounded-3 me-3"><i class="bi bi-hourglass-split fs-3"></i></div>
                                <div>
                                    <h6 class="text-muted mb-1">Terlambat</h6>
                                    <h4 class="mb-0 fw-bold">2 Kali</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="card card-custom h-100">
                            <div class="card-body d-flex align-items-center">
                                <div class="bg-info text-dark p-3 rounded-3 me-3"><i class="bi bi-info-circle fs-3"></i></div>
                                <div>
                                    <h6 class="text-muted mb-1">Izin / Sakit</h6>
                                    <h4 class="mb-0 fw-bold">1 Kali</h4>
                                </div>
                            </div>
                        </div>
                    </div> -->
                </div>

                <!-- Data Table Example -->

                        <div class="card-body p-0">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                    
                                        <th>Tanggal</th>
                                        <th>Jam Masuk</th>
                                        <th>Jam Keluar</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($absensi as $row)
                                    <tr>
                                    
                                        <td>{{ $row->tanggal }}</td>
                                        <td>{{ $row->jam_masuk ?? '-' }}</td>
                                        <td>{{ $row->jam_keluar ?? '-' }}</td>
                                        <td>
                                            @if ($row->status == 'hadir')
                                                <span class="badge bg-success">Hadir</span>
                                            @else
                                                <span class="badge bg-secondary">{{ $row->status }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-3">Belum ada data absensi</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>


                        
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
    </script>
</body>

</html>