<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function __construct()
    {
        // 1. Terapkan 'auth' pada SEMUA metode di controller ini
        $this->middleware('auth');

        // ATAU

        // 2. Terapkan 'auth' hanya pada metode 'index' dan 'show'
        // $this->middleware('auth')->only(['index', 'show']);

        // ATAU

        // 3. Terapkan 'auth' pada SEMUA metode KECUALI 'guestIndex' dan 'about'
        // $this->middleware('auth')->except(['guestIndex', 'about']);
    }

    public function dashboard()
{
    $user = Auth::user();

    if ($user->role === 'admin') {
        // Admin → panggil method untuk admin
        return $this->dashboardAdmin();
    }

    // Karyawan → panggil method untuk karyawan
    return $this->dashboardKaryawan();
}




    public function index(Request $request)
    {
        $user = Auth::user(); // ambil user yg login
        $bulan = $request->bulan ?? date('n');
        $tahun = $request->tahun ?? date('Y');

        if ($user->role === 'admin') {
            // Admin → lihat absensi semua karyawan
            $absensi = DB::table('absensi')
                ->join('users', 'users.id', '=', 'absensi.user_id')
                ->select(
                    'users.name',
                    'absensi.tanggal',
                    'absensi.jam_masuk',
                    'absensi.jam_keluar',
                    'absensi.status',
                    'absensi.lokasi_latitude',
                    'absensi.lokasi_longitude'
                )
                ->whereMonth('absensi.tanggal', $bulan)
                ->whereYear('absensi.tanggal', $tahun)
                ->orderBy('absensi.tanggal', 'desc')
                ->get();

            return view('dashboard', compact('absensi', 'bulan', 'tahun'));
        } else {
            // Karyawan → hanya lihat absensi sendiri
            $absensi = DB::table('absensi')
                ->where('user_id', $user->id)
                ->whereMonth('tanggal', $bulan)
                ->whereYear('tanggal', $tahun)
                ->orderBy('tanggal', 'desc')
                ->get();

            return view('dashboardkaryawan', compact('absensi', 'bulan', 'tahun'));
        }
    }


    public function dashboardadmin()
    {
        // Ambil bulan & tahun dari request atau default sekarang
        $bulan =  date('n');
        $tahun =  date('Y');
        $hari_ini = date('Y-m-d'); // tanggal hari ini

        // Total karyawan
        $total_karyawan = DB::table('users')->count();

        // Total hadir hari ini
        $hadir_hari_ini = DB::table('absensi')
        ->whereDate('tanggal', $hari_ini)
        ->where('status', 'hadir')
        ->count();

        // Total terlambat hari ini
        $terlambat_hari_ini = DB::table('absensi')
        ->whereDate('tanggal', $hari_ini)
        ->where('status', 'terlambat')
        ->count();

        // Ambil data absensi
        $absensi = DB::table('absensi')
            ->join('users', 'users.id', '=', 'absensi.user_id')
            ->select(
                'users.name',
                'absensi.tanggal',
                'absensi.jam_masuk',
                'absensi.jam_keluar',
                'absensi.status',
                'absensi.lokasi_latitude',
                'absensi.lokasi_longitude'
            )
            ->whereMonth('absensi.tanggal', $bulan)
            ->whereYear('absensi.tanggal', $tahun)
            ->orderBy('absensi.tanggal', 'desc')
            ->limit(10)
            ->get();
        
        // List hadir hari ini
        $list_hadir = DB::table('absensi')
            ->join('users', 'users.id', '=', 'absensi.user_id')
            ->whereDate('absensi.tanggal', $hari_ini)
            ->where('absensi.status', 'hadir')
            ->select('users.name', 'absensi.jam_masuk')
            ->get();

        // List terlambat hari ini
        $list_terlambat = DB::table('absensi')
            ->join('users', 'users.id', '=', 'absensi.user_id')
            ->whereDate('absensi.tanggal', $hari_ini)
            ->where('absensi.status', 'terlambat')
            ->select('users.name', 'absensi.jam_masuk')
            ->get();

        // Kirim ke view
        return view('dashboard', compact('absensi', 'bulan', 'tahun', 'total_karyawan', 'hadir_hari_ini', 'terlambat_hari_ini', 'list_hadir','list_terlambat'));
    }
    
    public function dashboardKaryawan()
    {
        $user_id = Auth::id();
        $bulan = date('n');
        $tahun = date('Y');

        $total_hadir = DB::table('absensi')
            ->where('user_id', $user_id)
            ->where('status', 'hadir')
            ->whereMonth('tanggal', $bulan)
            ->whereYear('tanggal', $tahun)
            ->count();

        $tepat_waktu = DB::table('absensi')
            ->where('user_id', $user_id)
            ->where('status', 'tepat_waktu')
            ->whereMonth('tanggal', $bulan)
            ->whereYear('tanggal', $tahun)
            ->count();

        $absensi = DB::table('absensi')
            ->where('user_id', $user_id)
            ->whereMonth('tanggal', $bulan)
            ->whereYear('tanggal', $tahun)
            ->orderBy('tanggal', 'desc')
            ->get();

        return view('dashboardkaryawan', compact('total_hadir', 'tepat_waktu', 'absensi', 'bulan', 'tahun'));
    }

  

}
  
    